# daily release selection

prep_daily_release_files <- function(release_by_ResOps_method,
                                     release_by_USGS_method,
                                     release_by_ISTARF_method,
                                     release_by_RoR_method,
                                     release_by_HUC4outlet_method){
  
  release_by_ResOps_method |> 
    left_join(release_by_USGS_method, join_by(date, RHPID)) |> 
    left_join(release_by_ISTARF_method, join_by(date, RHPID)) |> 
    left_join(release_by_RoR_method, join_by(date, RHPID)) |> 
    left_join(release_by_HUC4outlet_method, join_by(date, RHPID)) -> 
    all_data
  
  1980:2019 |> 
    map(function(yr){
      
      all_data |> 
        filter(year(date) == yr) |> 
        write_parquet(paste0("data/internals/daily_releases/",
                             yr, ".parquet"))
      
      return(NULL)
      
    })
  
  return("data/internals/daily_releases/")
  
}
 
assign_daily_release <- function(target_plants_mapped_to_water,
                                 daily_release_files){
  

  1980:2019 |> 
    map_dfr(function(year){

      read_parquet(paste0(daily_release_files, year, ".parquet")) ->
        all_data_yr
      
      target_plants_mapped_to_water[["RHPID"]] |> unique() |> 
        map_dfr(function(RHPID){

          # 1. try for ResOps
          all_data_yr |>
            filter(RHPID == !!RHPID) ->
            check
          
          if(!(sum(is.na(check[["RM1_ResOps"]])) > 14)){
            message(paste0(RHPID, "  |  ", year, "  |  Use ResOps!"))
            return(
              check |>
                rename(flow_cumecs = RM1_ResOps) |>
                mutate(data_from = "ResOps") |> 
                select(date, RHPID, flow_cumecs, data_from)
            )
          } 
          
          # 2. try for USGS downstream gauge
          
          if(!(sum(is.na(check[["RM2_USGS"]])) > 14)){
            message(paste0(RHPID, "  |  ", year, "  |  Use downstream USGS gauge!"))
            return(
              check |>
                rename(flow_cumecs = RM2_USGS) |>
                mutate(data_from = "downstream_USGS_gauge") |> 
                select(date, RHPID, flow_cumecs, data_from)
            )
          } 
          
          # 3. try for ISTARF
          if(!(sum(is.na(check[["RM3_ISTARF"]])) > 14)){
            message(paste0(RHPID, "  |  ", year, "  |  Use ISTARF!"))
            return(
              check |>
                rename(flow_cumecs = RM3_ISTARF) |>
                mutate(data_from = "ISTARF") |> 
                select(date, RHPID, flow_cumecs, data_from)
            )
          } 
          
          # 4. try for Dayflow (RoR only)
          
          if(!(sum(is.na(check[["RM4_RoR"]])) > 14)){
            message(paste0(RHPID, "  |  ", year, "  |  Use ISTARF!"))
            return(
              check |>
                rename(flow_cumecs = RM4_RoR) |>
                mutate(data_from = "Dayflow (RoR only)") |> 
                select(date, RHPID, flow_cumecs, data_from)
            )
          } 
          
          # 5. try for HUC4 outlet gauge
          message(paste0(RHPID, "  |  ", year, "  |  Use HUC4 outlet gauge!"))
          return(
            check |>
              rename(flow_cumecs = RM5_HUC4) |>
              mutate(data_from = "HUC4 outlet gauge") |> 
              select(date, RHPID, flow_cumecs, data_from)
          )
          
        })

    }) -> daily_release_by_dam
  
  daily_release_by_dam |> 
    # deal with small number of negative flow instances
    mutate(flow_cumecs = if_else(flow_cumecs < 0, 0, flow_cumecs)) ->
    daily_release_by_dam_non_zero
  
  return(daily_release_by_dam_non_zero)
  
}
